/**
 * Created by Huzaifa on 9/18/15.
 */
var $categories;
var $emp_allowance = {};
$(document).on('ready', function() {
    $('#form').valid();
});

$(document).on('change','#employee_registration_id',function() {
    var $employee_registration_id = $(this).val();
     $('#special_allowance_type_id').html('').trigger('change');
    $.ajax({
        url: $URLGetAllowedAllowanceType,
        dataType: 'json',
        type: 'post',
        data: '&employee_registration_id='+$employee_registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#employee_registration_id').before('<i id="loader" class="fa fa-spinner fa-spin"></i>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#special_allowance_type_id').html(json.html);

                // console.log(json);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
});

$(document).on('change','#special_allowance_type_id', function() {
    
    var $special_allowance_type_id = $('#special_allowance_type_id option:selected').val();
    var $employee_registration_id = $('#employee_registration_id option:selected').val();
    $('#tblPolicy tbody').html('');
    $('#tblApproved tbody').html('');
    $('#tblSpecialAllowance tbody').html('');
    if($special_allowance_type_id!='' && $employee_registration_id!='') {
        if($special_allowance_type_id==2) {
            $('#divPeriod').show('slow');
        } else {
            $('#medical_from').val('');
            $('#medical_to').val('');
            $('#divPeriod').hide('slow');
        }
        var $data = $('#employee_registration_id option:selected').data();
        $('#company_id').val($data['company_id']);
        $('#registration_code').val($data['registration_code']);

        $.ajax({
            url: $URLGetPolicy,
            dataType: 'json',
            type: 'post',
            data: 'company_id='+$data['company_id']+'&employee_registration_id='+$employee_registration_id+'&special_allowance_type_id='+$special_allowance_type_id,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#employee_registration_id').before('<i id="loader" class="fa fa-spinner fa-spin"></i>')
            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $emp_allowance = json.emp_allowances;
                    $('#divPolicy').html(json.html_policy);
                    $policies = json.policies;
                    $families = json.families;
                    $categories = json.categories;

                    $('#update_profile_message').show();
                    $('#tblApproved tbody').html(json.html_approved);
                    if(json.post['special_allowance_type_id']==1) {
                        $('#myModal').modal('show');
                        // show modal
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

$(document).on('click', '.btnAddAllowance', function() {
    var $employee_registration_id = $('#employee_registration_id option:selected').val();
    var $special_allowance_type_id = $('#special_allowance_type_id option:selected').val();
    if(Object.keys($families).length == 0) {
        alert('Please add Family Members in your Profile');
        return;
    }
    if(Object.keys($policies).length == 0) {
        alert('Policy not defined. Please contact Administrator');
        return;
    }
    if ($employee_registration_id!='' && $special_allowance_type_id!='') {
        //var $categories = $special_allowance_types[$special_allowance_type_id]['categories'];
        var $html = '';
        $html += '<tr id="grid_row_id_'+$grid_row_allowance+'" data-row_id="'+$grid_row_allowance+'">';
        $html += '<td style="width: 15px;"><a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>';
        $html += '<td>';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_allowance_for" name="details['+$grid_row_allowance+'][allowance_for]" value="" />';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_school_id" name="details['+$grid_row_allowance+'][school_id]" value="" />';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_class_id" name="details['+$grid_row_allowance+'][class_id]" value="" />';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_start_date" name="details['+$grid_row_allowance+'][period_start_date]" value="" />';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_end_date" name="details['+$grid_row_allowance+'][period_end_date]" value="" />';
        $html += '<select onchange="updateRelation('+$grid_row_allowance+');" class="form-control" id="detail_'+$grid_row_allowance+'_employee_family_id" name="details['+$grid_row_allowance+'][employee_family_id]" >';
        $html += '<option data-relation="" data-school_id="" data-class_id="" data-period_start_date="" data-period_end_date="" data-school="" value="">&nbsp;</option>';
        $.each($families,function($i,$family) {
            $html += '<option data-relation="'+$family['relation']+'" data-school_id="'+$family['school_id']+'" data-class_id="'+$family['class_id']+'" data-period_start_date="'+$family['period_start_date']+'" data-period_end_date="'+$family['period_end_date']+'" data-school="'+$family['school_name']+' - '+$family['class_name']+'" value="'+$family['employee_family_id']+'">'+$family['full_name']+'</option>';
        });
        $html += '</select>';
        $html += '</td>';
        $html += '<td>';
        $html += '<select class="form-control" id="detail_'+$grid_row_allowance+'_special_allowance_category_id" name="details['+$grid_row_allowance+'][special_allowance_category_id]" >';
        $html += '<option value="">&nbsp;</option>';
        $.each($categories,function($i,$category) {
            $html += '<option value="'+$category['special_allowance_category_id']+'">'+$category['special_allowance_category']+'</option>';
        });
        $html += '</select>';
        $html += '</td>';
        $html += '<td><input onchange="calculateTotal();" type="text" class="form-control fPDecimal text-right" id="detail_'+$grid_row_allowance+'_amount" name="details['+$grid_row_allowance+'][amount]" value="" /></td>';
        $html += '<td><input type="text" class="form-control" maxlength="60" id="detail_'+$grid_row_allowance+'_remarks" name="details['+$grid_row_allowance+'][remarks]" value="" /></td>';
        $html += '<td><input type="text" class="form-control dtpDate" id="detail_'+$grid_row_allowance+'_receipt_date" name="details['+$grid_row_allowance+'][receipt_date]" value="" /></td>';
        $html += '<td>';
        $html += '<input type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_receipt_no" name="details['+$grid_row_allowance+'][receipt_no]" value="" />';
        $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_on" name="details['+$grid_row_allowance+'][policy_on]" value="" />';
        $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_value" name="details['+$grid_row_allowance+'][policy_value]" value="" />';
        $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_amount" name="details['+$grid_row_allowance+'][policy_amount]" value="" />';
        $html += '</td>';
        $html += '</tr>';

        //$('#tblSpecialAllowance tbody').append($html);
        $('#tblSpecialAllowance tbody').prepend($html);
        $('#detail_'+$grid_row_allowance+'_employee_family_id').trigger('change');
        $grid_row_allowance++;
        setFieldFormat();
    } else {
        alert('Select Department and Allowance');
    }
});

function updateRelation($allowance_id) {
    var $data = $('#detail_'+$allowance_id+'_employee_family_id option:selected').data();
    var $family_id = $('#detail_'+$allowance_id+'_employee_family_id option:selected').val();
    var $employee_registration_id = $('#employee_registration_id').val();
    var $allowance_type_id = $('#special_allowance_type_id').val();
    // alert($employee_registration_id);
    $('#detail_'+$allowance_id+'_allowance_for').val($data['relation']);
    $('#detail_'+$allowance_id+'_school_id').val($data['school_id']);
    $('#detail_'+$allowance_id+'_class_id').val($data['class_id']);
    $('#detail_'+$allowance_id+'_period_start_date').val($data['period_start_date']);
    $('#detail_'+$allowance_id+'_period_end_date').val($data['period_end_date']);
}

$(document).on('click','.btnRemoveAllowance',function() {
    var $row_id = $(this).parent().parent().data('row_id');
    $('#grid_row_id_'+$row_id).remove();

    calculateTotal();
});

function calculateTotal() {
    // alert('hello');
    var $total_amount = 0;
    var $total_policy_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function () {
        var $row_id = $(this).data('row_id');
        var $relation = $('#detail_' + $row_id + '_allowance_for').val();
        var $category_id = $('#detail_' + $row_id + '_special_allowance_category_id option:selected').val();
        var $amount = $('#detail_' + $row_id + '_amount').val() | 0;

        if (typeof $policies[$relation] !== 'undefined') {
            if (typeof $policies[$relation][$category_id] !== 'undefined') {
                var $policy_on = $policies[$relation][$category_id]['allowance_on'];
                var $policy_value = $policies[$relation][$category_id]['allowance_value'];
            } else if (typeof $policies[$relation][0] !== 'undefined') {
                var $policy_on = $policies[$relation][0]['allowance_on'];
                var $policy_value = $policies[$relation][0]['allowance_value'];
            } else {
                var $policy_on = '';
                var $policy_value = 0;
            }
        } else {
            var $policy_on = '';
            var $policy_value = 0;
        }

        if ($policy_on == 'Fixed') {
            var $policy_amount = $amount;
        } else {
            var $policy_amount = (parseFloat($amount) * parseFloat($policy_value) / 100).toFixed(2);
        }
        $total_amount += parseFloat($amount);
        $total_policy_amount += parseFloat($policy_amount);

        $('#detail_' + $row_id + '_policy_amount').val($policy_amount);
        $('#detail_' + $row_id + '_policy_on').val($policy_on);
        $('#detail_' + $row_id + '_policy_value').val($policy_value);
    });

    $('#total_amount').val($total_amount);
}